/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPalette.cpp,v 1.1 1999/09/12 04:29:47 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CPalette.h"

_USING_PGP

// Class CPalette member functions

CPalette& 
CPalette::operator=(HPALETTE palette)
{
	Attach(palette);
	return *this;
}

void 
CPalette::Create(const LOGPALETTE& lp)
{
	Clear();
	mPalette = CreatePalette(&lp);

	if (IsNull(mPalette))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CPalette::CreateHalftone(HDC dc)
{
	pgpAssert(IsntNull(dc));

	Clear();
	mPalette = CreateHalftonePalette(dc);

	if (IsNull(mPalette))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CPalette::CreateDIB(const BITMAPINFO *pBMI, PGPUInt32& numColors)
{
	pgpAssertAddrValid(pBMI, BITMAPINFO);

	Clear();

	const BITMAPINFOHEADER	*pBMIH	= 
		reinterpret_cast<const BITMAPINFOHEADER *>(pBMI);

	if (pBMIH->biBitCount <= 8)
		numColors = (1 << pBMIH->biBitCount);
	else
		numColors = 0;	// no palette needed for 24 BPP DIB

	if (numColors > 0)
	{
		LOGPALETTE	*pLP	= reinterpret_cast<LOGPALETTE *>(new PGPByte[
			sizeof(LOGPALETTE) + sizeof(PALETTEENTRY)*numColors]);

		pLP->palVersion = 0x300;
		pLP->palNumEntries = numColors;

		for (PGPUInt32 i = 0; i < numColors; i++)
		{
			pLP->palPalEntry[i].peRed	= pBMI->bmiColors[i].rgbRed;
			pLP->palPalEntry[i].peGreen	= pBMI->bmiColors[i].rgbGreen;
			pLP->palPalEntry[i].peBlue	= pBMI->bmiColors[i].rgbBlue;
			pLP->palPalEntry[i].peFlags	= 0;
		}

		try
		{
			Create(*pLP);
		}
		catch (CComboError&)
		{
			delete[] pLP;
			throw;
		}

		delete[] pLP;
	}

	mWeCreated = TRUE;
}

void 
CPalette::Attach(HPALETTE palette)
{
	if (palette == mPalette)
		return;

	Clear();

	mWeCreated = FALSE;
	mPalette = palette;
}

void 
CPalette::Clear()
{
	if (WeCreated())
		DeleteObject(mPalette);

	mWeCreated = FALSE;
	mPalette = NULL;
}
